# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit meson flag-o-matic xdg

DESCRIPTION="a series of packages for handling media devices"
HOMEPAGE="https://git.linuxtv.org/v4l-utils.git"
SNAPSHOT=2ed8da243dd1e1eb1b1feebbefa04f089225d4f4
SRC_URI="https://github.com/gjasny/v4l-utils/archive/${SNAPSHOT}.tar.gz -> ${PN}-${SNAPSHOT}.tar.gz"
S=${WORKDIR}/v4l-utils-${SNAPSHOT}

LICENSE="LGPL"
SLOT="0"
KEYWORDS="amd64 arm64"

DEPEND="
	app-fs/sysfsutils
	xgui-lib/qtbase
	xgui-tools/alsa-lib
"

src_prepare() {
	append-flags "-D_FILE_OFFSET_BITS=64"
	filter-flags -flto*

	sed -i 's/\bmmap64\b/mmap/g' utils/v4l2-tracer/retrace.cpp || die
	sed -i 's/\bopen64\b/open/g' utils/v4l2-tracer/retrace.cpp || die

	default
}

src_install() {
	meson_src_install

	rm -r "${ED}"/usr/lib/gconv
}
