# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit toolchain-funcs flag-o-matic autotools

DESCRIPTION="WLAN tools for breaking 802.11 WEP/WPA keys"
HOMEPAGE="http://www.aircrack-ng.org"
SNAPSHOT=f333a6a767dc83c7da352de59dbca402fe3bf70c
SRC_URI="https://github.com/aircrack-ng/aircrack-ng/archive/${SNAPSHOT}.tar.gz -> aircrack-ng-${SNAPSHOT}.tar.gz"
S="${WORKDIR}/aircrack-ng-${SNAPSHOT}"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 arm64"

IUSE="airdrop-ng airgraph-ng netlink pcre sqlite experimental"

DEPEND="
	lib-net/libpcap
	virtual/ssl
	netlink? ( lib-net/libnl )
	pcre? ( lib-core/libpcre2 )
	experimental? ( lib-core/zlib )
	sqlite? ( lib-core/sqlite )
"
PDEPEND="
		app-net/iw
		app-net/ethtool
		app-var/usbutils
		app-core/pciutils
"

filter-flags -flto\=\*
append-flags -fcommon

src_prepare() {
	eautoreconf
	default
}

src_configure() {
	local myconf=(
		--bindir="${EPREFIX}"/usr/bin
		--sbindir="${EPREFIX}"/usr/bin
		--libdir="${EPREFIX}"/usr/lib
		--libexecdir="${EPREFIX}"/usr/libexec
		--sysconfdir="${EPREFIX}"/etc
		--localstatedir="${EPREFIX}"/var
		--disable-asan
		$(use_enable netlink libnl)
		--with-experimental
		$(use_with sqlite sqlite3)
		--enable-shared
		--disable-static
		--without-opt
	)
	ECONF_SOURCE=${S} econf "${myconf[@]}"
}

src_compile() {
	local MAKE_COMMON=(
		CC="$(tc-getCC)" \
		CXX="$(tc-getCXX)" \
		AR="$(tc-getAR)" \
		LD="$(tc-getLD)" \
		RANLIB="$(tc-getRANLIB)" \
	)
	emake "${MAKE_COMMON[@]}"
}

src_test() {
	local MAKE_COMMON=(
		CC="$(tc-getCC)" \
		CXX="$(tc-getCXX)" \
		AR="$(tc-getAR)" \
		LD="$(tc-getLD)" \
		RANLIB="$(tc-getRANLIB)" \
	)
	emake "${MAKE_COMMON[@]}" check
}

src_install() {
	local MAKE_COMMON=(
		CC="$(tc-getCC)" \
		CXX="$(tc-getCXX)" \
		AR="$(tc-getAR)" \
		LD="$(tc-getLD)" \
		RANLIB="$(tc-getRANLIB)" \
		DESTDIR="${ED}"
	)
	emake "${MAKE_COMMON[@]}" install
	rm "${ED}"/usr/sbin/airodump-ng-oui-update
}
