# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools flag-o-matic

DESCRIPTION="Standard (de)compression library"
HOMEPAGE="https://zlib.net/"
SNAPSHOT=2896db600d9f4520e036dd8f5d6e16ef54218f26
SRC_URI="https://github.com/madler/zlib/archive/${SNAPSHOT}.tar.gz -> ${PN}-${SNAPSHOT}.tar.gz"
S=${WORKDIR}/zlib-${SNAPSHOT}

LICENSE="ZLIB"
SLOT="0"
KEYWORDS="amd64 arm64"

IUSE="minizip static-libs"

src_prepare() {
	append-flags -ffat-lto-objects
	sed -i '/^  elif test -z.*$/,/^  fi$/c\  fi' configure

	default

	#ldconfig is not used
	sed -i 's/ldconfig/false/g' configure

	if use minizip ; then
		cd contrib/minizip || die
		eautoreconf
	fi
}

src_configure() {
	local myconf=(
		--shared
		--prefix="${EPREFIX}/usr"
		--libdir="${EPREFIX}/usr/lib"
	)
	ECONF_SOURCE=${S} ./configure "${myconf[@]}"

	if use minizip ; then
		local minizipdir="contrib/minizip"

		cd ${minizipdir} || die
		ECONF_SOURCE="${S}/${minizipdir}" econf $(use_enable static-libs static)
	fi
}

src_install() {
	default
	use static-libs || rm -f "${ED}"/usr/lib/libz.{a,la}

	if use minizip ; then
		emake -C contrib/minizip install DESTDIR="${D}"

		insinto /usr/include/minizip
		doins contrib/minizip/*.h

		rm -f "${ED}"/usr/lib/libminizip.la || die
	fi

}
